<?php
/*--------------------------------------------------------------
   Added.php 2021-06-02
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Statistics\App\Overview\Model\Events;

use Gambio\Admin\Modules\Statistics\App\Overview\Model\ValueObjects\Type;

class Added
{
    /**
     * @var Type
     */
    private $type;
    
    
    /**
     * Constructor.
     */
    private function __construct(Type $type)
    {
        $this->type = $type;
    }
    
    
    /**
     * Create instance.
     */
    public static function create(Type $type): self
    {
        return new self($type);
    }
    
    
    /**
     * Return type.
     */
    public function type(): Type
    {
        return $this->type;
    }
}